<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    protected $table = 'products';
    
    // Field yang boleh diisi
    protected $fillable = [
        'name', 'product_type_id', 'category_id', 'base_price', 
        'fixed_price', 'stock', 'image', 'description', 'is_active'
    ];

    public $timestamps = false; // Sesuaikan dengan DB Anda

    // --- TAMBAHAN PENTING DI SINI ---
    
    // 1. Beritahu Laravel untuk selalu menyertakan field 'attribute_schema' di JSON
    protected $appends = ['attribute_schema'];

    // 2. Relasi ke Tipe Produk (Wajib ada untuk mengambil schema)
    public function type()
    {
        return $this->belongsTo(ProductType::class, 'product_type_id');
    }

    // 3. Logika "Magic" untuk mengambil Schema
    public function getAttributeSchemaAttribute()
    {
        // Cek apakah produk punya schema khusus (override)
        // Gunakan @ untuk mencegah error jika kolom tidak ada di tabel products
        $custom = @$this->attributes['attribute_schema'];
        
        if (!empty($custom)) {
            $decoded = json_decode($custom);
            // Validasi format JSON
            if ($decoded) return $decoded;
        }

        // Jika tidak ada schema khusus, AMBIL DARI TIPE PRODUK
        // Kita gunakan $this->type (Relasi)
        if ($this->type && !empty($this->type->attribute_schema)) {
            return json_decode($this->type->attribute_schema);
        }

        return null;
    }
}