<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;
// Jangan lupa import Model di paling atas
use App\Models\Category;
use App\Models\ProductType;



class ProductController extends Controller
{
    public function index(Request $request)
    {
    // Mulai Query
    // PENTING: Tambahkan ->with('type') agar relasi terbaca
    $query = Product::with('type')->where('is_active', 1);

    // Logika Pencarian (Search)
    if ($request->has('search') && !empty($request->search)) {
        $search = $request->search;
        $query->where('name', 'LIKE', "%{$search}%");
    }

    // Logika Filter Kategori
    if ($request->has('category') && $request->category != 'all' && !empty($request->category)) {
        // Kita cari ID kategori berdasarkan namanya dulu (karena frontend kirim nama)
        $catName = $request->category;
        $catId = \App\Models\Category::where('name', $catName)->value('id');
        
        if($catId) {
            $query->where('category_id', $catId);
        }
    }

    $products = $query->get();

    return response()->json([
        'status' => 'success',
        'data' => $products
    ]);
    }

// Tambahkan method ini di dalam class ProductController
public function categories()
{
    $data = Category::all();
    return response()->json(['status' => 'success', 'data' => $data]);
}

public function types()
{
    $data = ProductType::all();
    return response()->json(['status' => 'success', 'data' => $data]);
}    


    
    
    
}