<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Order;
use App\Models\OrderItem;
use App\Models\Product;

class OrderController extends Controller
{
    public function store(Request $request)
    {
        // Validasi Input
        $request->validate([
            'customer_name' => 'required',
            'items' => 'required|array'
        ]);

        DB::beginTransaction(); // Agar aman (Rollback jika gagal di tengah)

        try {
            // 1. Buat Order Utama
            $order = Order::create([
                'customer_name' => $request->customer_name,
                'customer_phone' => $request->customer_phone ?? '-',
                'customer_email' => $request->customer_email ?? null,
                'customer_address' => $request->customer_address ?? null,
                'status' => 'pending',
                'total_amount' => 0, // Nanti diupdate
                'order_date' => now(),
                // 'api_key_id' => ... (Logic API Key bisa ditambahkan nanti)
            ]);

            $grandTotal = 0;

            // 2. Loop Items
           // ... (Bagian atas function store sama) ...

foreach ($request->items as $item) {
    // Ambil produk beserta info Tipe-nya
    $product = Product::with('type')->find($item['product_id']);
    
    if (!$product) continue;

    $qty = floatval($item['qty']); // Bisa berupa jumlah unit atau luas area (m2)
    $basePrice = floatval($product->base_price);
    $fixedPrice = floatval($product->fixed_price);
    
    // Cek Mode Hitungan dari Tipe Produk
    $mode = $product->type ? $product->type->calculation_mode : 'unit';
    $subtotal = 0;

    // Tiru logika dari api.php lama (baris 326)
    if ($mode == 'unit_fixed' || $mode == 'area_fixed') {
        // Rumus: (Qty/Area * Harga Dasar) + Biaya Tetap
        $subtotal = ($qty * $basePrice) + $fixedPrice;
    } else {
        // Rumus: Qty/Area * Harga Dasar
        $subtotal = $qty * $basePrice;
    }

    // Simpan Item
    OrderItem::create([
        'order_id' => $order->id,
        'product_id' => $product->id,
        'product_name' => $product->name,
        'quantity' => $qty,
        'price' => $basePrice, 
        'subtotal' => $subtotal, // Subtotal yang sudah benar
        'product_attributes' => json_encode($item['attributes'] ?? [])
    ]);

    $grandTotal += $subtotal;
}

// ... (Sisa function store ke bawah sama) ...

            // 3. Update Total Order
            $order->update(['total_amount' => $grandTotal]);

            DB::commit();

            return response()->json([
                'status' => 'success',
                'message' => 'Order Created',
                'order_id' => $order->id
            ]);

        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json(['status' => 'error', 'message' => $e->getMessage()], 500);
        }
    }
}