<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Models\Customer;
use App\Models\KmAgent;

class AuthController extends Controller
{
    public function login(Request $request)
    {
        $username = $request->username;
        $password = $request->password;

        // 1. Cek Login sebagai AGENT/POINT (Prioritas)
        $agent = KmAgent::where(function($query) use ($username){
                    $query->where('username', $username)
                          ->orWhere('no_telepon', $username)
                          ->orWhere('email', $username);
                 })->where('is_active', 1)->first();

        if ($agent && Hash::check($password, $agent->password)) {
            return response()->json([
                'status' => 'success',
                'message' => 'Login Berhasil (Agent/Point)',
                'user' => [
                    'id' => $agent->id,
                    'name' => $agent->nama_lengkap,
                    'username' => $agent->username,
                    'phone' => $agent->no_telepon,
                    'role' => $agent->tipe_anggota ?? 'agent'
                ]
            ]);
        }

        // 2. Cek Login sebagai CUSTOMER Biasa
        $customer = Customer::where('username', $username)
                            ->orWhere('phone', $username)
                            ->first();

        if ($customer && Hash::check($password, $customer->password)) {
            return response()->json([
                'status' => 'success',
                'message' => 'Login Berhasil',
                'user' => [
                    'id' => $customer->id,
                    'name' => $customer->name,
                    'username' => $customer->username,
                    'phone' => $customer->phone,
                    'role' => 'customer'
                ]
            ]);
        }

        return response()->json(['status' => 'error', 'message' => 'Username atau Password salah.'], 401);
    }

    public function register(Request $request)
    {
        // Cek duplikasi
        $exist = Customer::where('username', $request->username)
                         ->orWhere('phone', $request->phone)
                         ->exists();
        
        if ($exist) {
            return response()->json(['status' => 'error', 'message' => 'Username/HP sudah terdaftar.']);
        }

        $customer = Customer::create([
            'name' => $request->name,
            'username' => $request->username,
            'password' => Hash::make($request->password), // Enkripsi Password
            'email' => $request->email,
            'phone' => $request->phone,
            'address' => $request->address
        ]);

        return response()->json(['status' => 'success', 'message' => 'Pendaftaran berhasil!']);
    }
}